﻿<?xml version="1.0" encoding="UTF-8"?>
<?LassoScript
	/*
			This file functions much like the normal index.lasso file, except
		that it receives AJAX style requests only. Therefore it does not return
		a regular XHTML page, but only a part of a regular XHTML page. The
		returned section is then inserted into the calling document.
	*/
	var('LJAX' = true);

	// Include the library file which contains many of the tags 
	// that are utilized in these examples.
	library((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'library.lasso');
	
	// When running as an LJAX request, these pages handle simple tasks such as
	// returning the next "page" of messages, or the submittal of a new message reply, etc.
	// All resulting data must be a valid XML document, at least as far as
	// the calling XMLHttpReqeust is concerned.
	// the proper content-type has already been set in the ../library.lasso file.

	session_start: -name='ajax', -usecookie;
	
	'<ljax>';
	
	if: (action_param: 'log') != '';
		log_always: (action_param: 'log');
	/if;

	if: (action_param: 'target') >> 'theta_target';

		'<div id="theta_content" xmlns="http://www.w3.org/1999/xhtml">';
			'The time and date are';
			'<br />' + date->(format: '%D %T');
		'</div>';
	
	else: (action_param: 'target') >> 'eta_target';

		'<div id="eta_content" xmlns="http://www.w3.org/1999/xhtml">';
			'The time and date are';
			'<br />' + date->(format: '%D %T');
			'<br /><small>The content of this panel is updated every second.</small>';
		'</div>';
	
	else: (action_param: 'target') !>> 'none';
	
		include('examples/template.lasso');
	
	/if;
	
	'</ljax>';
?>
